'use strict';

/* --------------------------------------------------------------
	paypalinstallmentsinfo.js 2017-01-13
	Gambio GmbH
	http://www.gambio.de
	Copyright (c) 2016 Gambio GmbH
	Released under the GNU General Public License (Version 2)
	[http://www.gnu.org/licenses/gpl-2.0.html]
	--------------------------------------------------------------
*/

gambio.widgets.module('paypalinstallmentsinfo', [], function (data) {
    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        defaults = {
        thirdPartyPaymentsBlock: []
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    module.init = function (done) {
        var addCloseHandler = function addCloseHandler() {
            $('div.pp_cs_popup, div.pp_cs_popup button.mfp-close').on('click', function (e) {
                $(e.target).closest('div.pp_cs_popup').remove();
            });
        };

        $('div.popup_installments_info', $this).on('click', function (e) {
            var $popup = $('.pp_cs_popup', $this),
                $newpopup = void 0,
                amount = $(e.target).data('amount');

            if (amount === 'dynamic') {
                var priceText = $('#attributes-calc-price div.current-price-container').text(),
                    dynamount;
                dynamount = priceText.replace(/(.*?[\d.,]+\s\S+)?.*?([.,\d]+)\s\S+(.+%)?$/, '$2');
                dynamount = dynamount.replace(/[,.](\d{3})/g, '$1').replace(/(\d+)[.,](\d\d)/, '$1.$2');
                amount = dynamount;
            }

            $('body > div.pp_cs_popup').remove();
            $popup.clone().appendTo('body');
            addCloseHandler();
            $('body > div.pp_cs_popup').show();

            if ($('body > div.pp_cs_popup > div.pp_cs_popup_inner').length === 0) {
                var contentUrl = jse.core.config.get('appUrl') + '/shop.php?do=PayPal/InstallmentOptions';
                $('body > div.pp_cs_popup').load(contentUrl, { 'amount': amount }, function () {
                    $('div.pp_cs_popup button.mfp-close').on('click', addCloseHandler);
                });
            }
        });
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
